 ; Ŀ
 ;   Wm - Move word to next line.                                          
 ;   Copyright 1990, 1998, 2002, 2004, 2006 - 2008 by Rocket Software Ltd. 
 ;   Software for those who want to make the big bucks                     
 ;   and get the good looking women.                                       
 ; 

 ; Ŀ
 ;   1stwrd - divide the argument (a text string) at a space into the      
 ;   first word and the remainder of the string.                           
 ;   Returns a list thereof.                                               
 ; 
 (DEFUN 1STWRD (txa / lena last first len)
  (setq lena 1)
  (while (and (> (strlen txa) lena) (= (substr txa lena 1) " "))
         (setq lena (1+ lena)))
  (while (and (> (strlen txa) lena) (/= (substr txa lena 1) " "))
         (setq lena (1+ lena)))
  (if (/= (strlen txa) lena)                      ; if a > 1 word
      (progn
           (setq last (substr txa (1+ lena)))     ; text after space
           (setq first (substr txa 1 (1- lena)))) ; word up to space
      (progn                                      ; if a = only 1 word
           (if (= (substr txa (setq len (strlen txa))) " ")
               (setq txa (substr txa 1 (1- len))))
           (setq first txa)
           (setq last "")))
 (list first last))
 ; Ŀ
 ;   1stwrd end.                                                           
 ; 

 ; Ŀ
 ;   Endwrd - divide the argument (a text string) at a space into the      
 ;   first part and the last word.                                         
 ;   Returns a list thereof.                                               
 ; 
 (DEFUN ENDWRD (txa / lena last first)
  (setq lena (strlen txa))      ; length of line a
  (while (and (< 0 lena) (= (substr txa lena 1) " "))
         (setq lena (1- lena)))
  (while (and (< 0 lena) (/= (substr txa lena 1) " "))
         (setq lena (1- lena)))
  (if (/= 0 lena)
      (progn
           (setq last (substr txa (1+ lena)))      ; word after space
           (setq first (substr txa 1 (1- lena))))  ; text up to space
      (progn
           (setq last txa)                         ; whole word
           (setq first "")))                       ; empty string
 (list first last))
 ; Ŀ
 ;   Endwrd end.                                                           
 ; 

 ; Ŀ
 ;   Griz - a replacement for the entsel function - returns a list in the  
 ;   (ename point) format unless there was no entity at that point, in     
 ;   which case (nil point) is returned.                                   
 ;   Takes one argument, a prompt string.                                  
 ; 
 (DEFUN GRIZ (prom / pa ss enampt typ entt enam str renam outer)
  (princ prom)
  (while (and (setq pa (grread t 5 2))
              (/= (car pa) 6)
              (/= (car pa) 3)))
  (setq pa (cadr pa))
 ; Ŀ
 ;   See if there is a text or attribute entity at that point.             
 ; 
  (if (setq enampt (nentselp pa))
      (progn
           (setq enam (car enampt))
           (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
           (cond ((= "MTEXT" typ)
                  (prompt "Mtext is best edited with the mtext editor.")
                  (exit))
                 ((or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
                  (princ (setq str (cdr (assoc 1 entt))))
                  (redraw (setq renam (cdr (assoc -1 entt))) 3)
                  (setq outer (car (reverse (car (reverse enampt))))))
                 (t (setq enam nil)))))
 ; Ŀ
 ;   Return various data.                                                  
 ; 
 (list enam pa renam outer))
 ; Ŀ
 ;   Griz end.                                                             
 ; 

 ; Ŀ
 ;   Isab - see if a point or the insertion of a text entity is above or   
 ;   below a text entity relative to the orientation of the latter.        
 ;   Arguments: Entt1 - the base text entity data list.                    
 ;              Entt2 - either the entity data list of the entity whose    
 ;                      relative position we want, or a point.             
 ;   Returns the position of the destination entity or point relative to   
 ;   the source.                                                           
 ;   Calls spit.                                                           
 ; 
 (DEFUN ISAB (entt1 entt2 / rota1a rota1b ten1 ten2 rota2)
 ; Ŀ
 ;   Get the rotation angle of the text, and the opposite angle.           
 ; 
  (setq rota1a (cdr (assoc 50 entt1)))
  (if (< rota1a pi)
      (setq rota1b (+ rota1a pi))
      (setq rota1b (- rota1a pi)))
 ; Ŀ
 ;   Get the angle from the insertion point of the source text to the      
 ;   insertion point of the destination text.  Am using insertions         
 ;   rather than ten points just because it seems more likely to be        
 ;   what the user wants.                                                  
 ; 
  (setq ten1 (spit entt1))
 ; Ŀ
 ;   If the second argument is a data list, extract the insertion.         
 ;   Otherwise use it as a point.                                          
 ; 
  (if (> (length entt2) 3)
      (setq ten2 (spit entt2))
      (setq ten2 entt2))
  (setq rota2 (angle ten1 ten2))
 ; Ŀ
 ;   Will cover all conditions here, just for the sake of completeness.    
 ;   Also the code can do its own error checking.  Realistically should    
 ;   be able to only check for Above and call everything else Below.       
 ; 
  (cond ((and (> rota1a rota1b) (> rota1a rota2) (> rota1b rota2))
         "above")
        ((and (> rota1a rota1b) (> rota1a rota2) (< rota1b rota2))
         "below")
        ((and (> rota1a rota1b) (< rota1a rota2) (< rota1b rota2))
         "above")
        ((and (< rota1a rota1b) (> rota1a rota2) (> rota1b rota2))
         "below")
        ((and (< rota1a rota1b) (< rota1a rota2) (> rota1b rota2))
         "above")
        ((and (< rota1a rota1b) (< rota1a rota2) (< rota1b rota2))
         "below")
        (T (write-line "*error* - unrecognized alignment."))))
 ; Ŀ
 ;   Isab end.                                                             
 ; 

 ; Ŀ
 ;   Justo - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.  "none" is         
 ;   returned for standard left justification.                             
 ; 
 (DEFUN JUSTO (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "b"))      ; bottom
        ((= yjust 2) (setq yjst "m"))      ; middle
        ((= yjust 3) (setq yjst "t")))     ; top
  (cond ((= xjust 0) (setq xjst "l"))      ; left
        ((= xjust 1) (setq xjst "c"))      ; centre
        ((= xjust 2) (setq xjst "r"))      ; right
        ((= xjust 3) (setq xjst "a"))      ; aligned
        ((= xjust 4) (setq xjst "m"))      ; middle
        ((= xjust 5) (setq xjst "f")))     ; fit
  (setq justrg (strcat yjst xjst))
 (if (= justrg "l") "none" justrg))
 ; Ŀ
 ;   Justo end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text or attdef entity       
 ;   whose data was passed as its sole argument.  Note that this is        
 ;   not necessarily the same as the 10 association code.                  
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Succ - copy an attribute or text entity as a text entity.  
 ;   Arguments: Entt, an entity data list.                                 
 ;              Astra, a new string, if nil then the existing one is used. 
 ;   Calls nothing, returns the ename of the new entity.                   
 ; 
 (DEFUN SUCC (entt astra / bbf nn sublst asonum)
  (setq bbf (list (cons 0 "TEXT")))
  (setq nn 0)
  (while (setq sublst (nth nn entt))
         (setq asonum (car sublst))
         (cond ((not (or (= -1 asonum)
                         (= 1 asonum)
                         (= 0 asonum)
                         (= 2 asonum)
                         (= 3 asonum)
                         (= 5 asonum)
                         (= 70 asonum)
                         (= 74 asonum)
                         (= 73 asonum)
                         (= 100 asonum)
                         (= 280 asonum)))
                (setq bbf (cons sublst bbf)))
               ((= 1 asonum)
                (if astra
                    (setq bbf (cons (cons 1 astra) bbf))
                    (setq bbf (cons sublst bbf))))
               ((= 74 asonum)
                (setq bbf (cons (cons 73 (cdr sublst)) bbf))))
         (setq nn (1+ nn)))
  (if (null (assoc 73 bbf))
            (setq bbf (cons (assoc 73 entt) bbf)))
  (setq bbf (reverse bbf))
  (entmake bbf)
 (entlast))
 ; Ŀ
 ;   Succ end.                                                             
 ; 

 ; Ŀ
 ;   Wm.                                                                   
 ; 
 (DEFUN C:WM (/ prev *error* snapp aa lina bb linb pa pb rela newreq txa txb
                renama renamb outera outerb enama enamb entt txlst ntxb ntxa
                                                                        enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if snapp (setvar "snapmode" snapp))
   (if renama (redraw renama 4))
   (if renamb (redraw renamb 4))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get the source text entity.                                           
 ;   Griz returns: (enam pa renam outer).                                  
 ;   If there was no entity there then this becomes (nil pa nil nil).      
 ;   Note: neither nentsel nor nentselp seems to work correctly any more.  
 ;   Among other things the entire set of matrix data is left out.         
 ;   Later: this is apparently only for non-nested entities, which seems   
 ;   to include attributes.                                                
 ; 
  (if (and (setq aa (griz "\nSource text: "))
           (setq enama (car aa))
           (setq lina (entget enama))
 ; Ŀ
 ;   If there was a source entity then get the destination entity or a     
 ;   point.                                                                
 ; 
           (setq bb (griz "\nDestination text or pick new text position: "))
           (setq pb (cadr bb))
           (setq enamb (car bb)))
      (progn
           (setq linb (entget enamb))
           (member (cdr (assoc 0 linb)) '("ATTDEF" "ATTRIB" "TEXT"))))
 ; Ŀ
 ;   Get the redraw and regen entity names for both entities, if any.      
 ; 
  (if lina
      (progn
           (setq renama (caddr aa))
           (setq outera (cadddr aa))))
  (if linb
      (progn
           (setq renamb (caddr bb))
           (setq outerb (cadddr bb))))
 ; Ŀ
 ;   See if a new line is required, and if the destination is above or     
 ;   below the source.                                                     
 ; 
  (cond ((and lina linb)
         (setq rela (isab lina linb)))
        (lina
         (setq rela (isab lina pb))
         (setq newreq t)))
 ; Ŀ
 ;   Condition 1: The second line (the destination) was above the first    
 ;                (the source).                                            
 ; 
  (cond ((and (null newreq) (= rela "above"))
         (setq txa (cdr (assoc 1 lina)))
         (setq txb (cdr (assoc 1 linb)))
         (setq txlst (1stwrd txa))
         (setq ntxb (strcat txb " " (car txlst)))
         (setq ntxa (cadr txlst))
         (if (and (member ntxa '("" " " "  "))
                  (= (cdr (assoc 0 lina)) "TEXT"))
             (entdel enama)
             (entmod (subst (cons 1 ntxa) (cons 1 txa) lina)))
         (entmod (subst (cons 1 ntxb) (cons 1 txb) linb))
         (entupd enama)
         (entupd enamb)
         (if (= (type outera) 'ENAME) (entupd outera))
         (if (= (type outerb) 'ENAME) (entupd outerb)))
 ; Ŀ
 ;   Condition 2: The destination was below the source.                    
 ; 
        ((and (null newreq) (= rela "below"))
         (setq txa (cdr (assoc 1 lina)))  ; text of line a 
         (setq txb (cdr (assoc 1 linb)))  ; text of line b 
         (setq txlst (endwrd txa))
         (setq ntxb (strcat (cadr txlst) " " txb))
         (setq ntxa (car txlst))
         (if (and (member ntxa '("" " " "  "))
                  (= (cdr (assoc 0 lina)) "TEXT"))
             (entdel enama)
             (entmod (subst (cons 1 ntxa) (cons 1 txa) lina)))
         (entmod (subst (cons 1 ntxb) (cons 1 txb) linb))
         (entupd enama)
         (entupd enamb)
         (if (= (type outera) 'ENAME) (entupd outera))
         (if (= (type outerb) 'ENAME) (entupd outerb)))
 ; Ŀ
 ;   Condition 3: A new line is required above the existing one.           
 ; 
        ((= rela "above")
         (setq txa (cdr (assoc 1 lina)))  ; text of line a 
         (setq txlst (1stwrd txa))
         (setq ntxb (car txlst))
         (setq ntxa (cadr txlst))
         (setq enam (succ lina ntxb))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq pb (polar pa (+ (/ pi 2) (cdr (assoc 50 entt)))
                            (* (cdr (assoc 40 entt)) 1.65)))
         (command "move" enam "" pa pb)
         (if (and (member ntxa '("" " " "  "))
                  (= (cdr (assoc 0 lina)) "TEXT"))
             (entdel enama)
             (entmod (subst (cons 1 ntxa) (cons 1 txa) lina)))
         (entupd enama)
         (if (= (type outera) 'ENAME) (entupd outera)))
 ; Ŀ
 ;   Condition 4: A new line is required below the existing one.           
 ; 
        ((= rela "below")
         (setq txa (cdr (assoc 1 lina)))  ; text of line a 
         (setq txlst (endwrd txa))
         (setq ntxb (cadr txlst))
         (setq ntxa (car txlst))
         (setq enam (succ lina ntxb))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq pb (polar pa (+ (* pi 1.5) (cdr (assoc 50 entt)))
                            (* (cdr (assoc 40 entt)) 1.65)))
         (command "move" enam "" pa pb)
         (if (and (member ntxa '("" " " "  "))
                  (= (cdr (assoc 0 lina)) "TEXT"))
             (entdel enama)
             (entmod (subst (cons 1 ntxa) (cons 1 txa) lina)))
         (entupd enama)
         (if (= (type outera) 'ENAME) (entupd outera))))
 ; Ŀ
 ;   Reset the error handler and end.                                      
 ; 
  (*error* "")
 (princ))